<?php $__env->startSection('content'); ?>
    <div class="job-category-section mb-120 mt-60">
        <div class="container">
            <div class="job-category-wrapper">
                <div class="category-sidebar">
                    <span class="sidebar-filter__close d-xl-none d-flex"><i class="las la-times"></i></span>
                    <div class="accordion sidebar--acordion">
                        <div class="filter-block">
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button" data-bs-toggle="collapse" data-bs-target="#budget"
                                        type="button" aria-expanded="true">
                                        <?php echo app('translator')->get('Budget'); ?>
                                    </button>
                                </h2>
                                <div class="accordion-collapse show collapse" id="budget">
                                    <div class="accordion-body">
                                        <ul class="filter-block__list">
                                            <li class="filter-block__item">
                                                <div class="project-value">
                                                    <input class="form--control" name="min_budget" type="number"
                                                        placeholder="<?php echo app('translator')->get('Min'); ?>">
                                                    <span class="project-value__text"> <?php echo app('translator')->get('to'); ?> </span>
                                                    <input class="form--control" name="max_budget" type="number"
                                                        placeholder="<?php echo app('translator')->get('Max'); ?>">
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="filter-block">
                            <h2 class="accordion-header">
                                <button class="accordion-button" data-bs-toggle="collapse" data-bs-target="#category"
                                    type="button" aria-expanded="true">
                                    <?php echo app('translator')->get('Categories'); ?>
                                </button>
                            </h2>
                            <div class="accordion-collapse show collapse" id="category">
                                <div class="accordion-body">
                                    <ul class="filter-block__list category">
                                        <li class="filter-block__item">
                                            <div class="form--check">
                                                <input class="form-check-input" id="subcat_all"
                                                    name="category_id" type="radio" value=""
                                                    <?php if(!request()->category_id): echo 'checked'; endif; ?>>
                                                <label class="form-check-label" for="subcat_all">
                                                    <span class="label-text"> <?php echo app('translator')->get('All'); ?> </span>
                                                    <span class="label-text"> (<?php echo e($categories->sum('jobs_count')); ?>) </span>
                                                </label>
                                            </div>
                                        </li>
                                        <?php $__empty_1 = true; $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <li class="filter-block__item">
                                                <div class="form--check">
                                                    <input class="form-check-input" id="subcat_<?php echo e($category->id); ?>"
                                                        name="category_id" type="radio" value="<?php echo e($category->id); ?>"
                                                        <?php if($category->id == request()->category_id): echo 'checked'; endif; ?>>
                                                    <label class="form-check-label" for="subcat_<?php echo e($category->id); ?>">
                                                        <span class="label-text"> <?php echo e(__($category->name)); ?> </span>
                                                        <span class="label-text"> (<?php echo e($category->jobs_count); ?>) </span>
                                                    </label>
                                                </div>
                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <li class="filter-block__item"> <?php echo app('translator')->get('Categories not found!'); ?></li>
                                        <?php endif; ?>
                                        <li class="load-more-button text-end"><?php echo app('translator')->get('Show more'); ?></li>
                                    </ul>
                                </div>
                            </div>
                        </div>

                        <div class="filter-block">
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button" data-bs-toggle="collapse" data-bs-target="#subcategory"
                                        type="button" aria-expanded="true">
                                        <?php echo app('translator')->get('Specialities'); ?>
                                    </button>
                                </h2>
                                <div class="accordion-collapse show collapse" id="subcategory">
                                    <div class="accordion-body">
                                        <ul class="filter-block__list">
                                            <?php $__empty_1 = true; $__currentLoopData = $subcategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <li class="filter-block__item">
                                                    <div class="form--check">
                                                        <input class="form-check-input" id="sub_<?php echo e($subcategory->id); ?>"
                                                            name="subcategory_id" type="checkbox"
                                                            value="<?php echo e($subcategory->id); ?>">
                                                        <label class="form-check-label" for="sub_<?php echo e($subcategory->id); ?>">
                                                            <span class="label-text"><?php echo e(__($subcategory->name)); ?></span>
                                                            <span class="label-text"> (<?php echo e($subcategory->jobs_count); ?>)
                                                            </span>
                                                        </label>
                                                    </div>
                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <li class="filter-block__item"> <?php echo app('translator')->get('Speciality not found!'); ?></li>
                                            <?php endif; ?>
                                            <li class="load-more-button text-end"><?php echo app('translator')->get('Show more'); ?></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="filter-block">
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button" data-bs-toggle="collapse" data-bs-target="#scope"
                                        type="button" aria-expanded="true">
                                        <?php echo app('translator')->get('Project Scope'); ?>
                                    </button>
                                </h2>
                                <div class="accordion-collapse show collapse" id="scope">
                                    <div class="accordion-body">
                                        <ul class="filter-block__list">
                                            <li class="filter-block__item">
                                                <div class="form--check">
                                                    <input class="form-check-input" id="large" name="project_scope[]"
                                                        type="checkbox" value="<?php echo e(Status::SCOPE_LARGE); ?>">
                                                    <label class="form-check-label" for="large">
                                                        <span class="label-text"> <?php echo app('translator')->get('Large'); ?> </span>
                                                        <span class="label-text"> (<?php echo e($counting['large']); ?>) </span>
                                                    </label>
                                                </div>
                                            </li>
                                            <li class="filter-block__item">
                                                <div class="form--check">
                                                    <input class="form-check-input" id="medium" name="project_scope[]"
                                                        type="checkbox" value="<?php echo e(Status::SCOPE_MEDIUM); ?>">
                                                    <label class="form-check-label" for="medium">
                                                        <span class="label-text"> <?php echo app('translator')->get('Medium'); ?> </span>
                                                        <span class="label-text"> (<?php echo e($counting['medium']); ?>) </span>
                                                    </label>
                                                </div>
                                            </li>
                                            <li class="filter-block__item">
                                                <div class="form--check">
                                                    <input class="form-check-input" id="small" name="project_scope[]"
                                                        type="checkbox" value="<?php echo e(Status::SCOPE_SMALL); ?>">
                                                    <label class="form-check-label" for="small">
                                                        <span class="label-text"> <?php echo app('translator')->get('Small'); ?> </span>
                                                        <span class="label-text"> (<?php echo e($counting['small']); ?>) </span>
                                                    </label>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="filter-block">
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button" data-bs-toggle="collapse" data-bs-target="#level"
                                        type="button" aria-expanded="true">
                                        <?php echo app('translator')->get('Experience Level'); ?>
                                    </button>
                                </h2>
                                <div class="accordion-collapse show collapse" id="level">
                                    <div class="accordion-body">
                                        <ul class="filter-block__list">
                                            <li class="filter-block__item">
                                                <div class="form--check">
                                                    <input class="form-check-input" id="pro-level" name="skill_level[]"
                                                        type="checkbox" value="1">
                                                    <label class="form-check-label" for="pro-level">
                                                        <span class="label-text"> <?php echo app('translator')->get('Pro Level'); ?></span>
                                                        <span class="label-text"> (<?php echo e($counting['pro']); ?>) </span>
                                                    </label>
                                                </div>
                                            </li>
                                            <li class="filter-block__item">
                                                <div class="form--check">
                                                    <input class="form-check-input" id="expart" name="skill_level[]"
                                                        type="checkbox" value="2">
                                                    <label class="form-check-label" for="expart">
                                                        <span class="label-text"> <?php echo app('translator')->get('Expart'); ?> </span>
                                                        <span class="label-text"> (<?php echo e($counting['expert']); ?>) </span>
                                                    </label>
                                                </div>
                                            </li>
                                            <li class="filter-block__item">
                                                <div class="form--check">
                                                    <input class="form-check-input" id="intermediate"
                                                        name="skill_level[]" type="checkbox" value="3">
                                                    <label class="form-check-label" for="intermediate">
                                                        <span class="label-text"><?php echo app('translator')->get('Intermediate'); ?> </span>
                                                        <span class="label-text"> (<?php echo e($counting['intermediate']); ?>)
                                                        </span>
                                                    </label>
                                                </div>
                                            </li>
                                            <li class="filter-block__item">
                                                <div class="form--check">
                                                    <input class="form-check-input" id="entry" name="skill_level[]"
                                                        type="checkbox" value="4">
                                                    <label class="form-check-label" for="entry">
                                                        <span class="label-text"><?php echo app('translator')->get('Entry'); ?> </span>
                                                        <span class="label-text"> (<?php echo e($counting['entry']); ?>) </span>
                                                    </label>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="job-category-body">
                    <div class="job-category-body__bar d-xl-none d-block">
                        <span class="job-category-body__bar-icon"><i class="las la-list"></i></span>
                    </div>
                    <div class="job-category-body__top">
                        <div class="search-container">
                            <input class="form--control" name="search" type="search" value="<?php echo e(request()->search); ?>"
                                placeholder="<?php echo app('translator')->get('Type job keyword'); ?>" autocomplete="off">
                            <span class="search-container__icon"> <i class="las la-search"></i> </span>
                        </div>
                    </div>
                    <div class="job-category-body__content">
                        <?php echo $__env->make('Template::job_explore.job', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        
        $(document).ready(function() {
            "use strict";

            function getFilters() {
                return {
                    min_budget: $('input[name="min_budget"]').val(),
                    max_budget: $('input[name="max_budget"]').val(),
                    category_id: $('input[name="category_id"]:checked').val(),
                    subcategory_id: $('input[name="subcategory_id"]:checked').map(function() {
                        return $(this).val();
                    }).get(),
                    project_scope: $('input[name="project_scope[]"]:checked').map(function() {
                        return $(this).val();
                    }).get(),
                    skill_level: $('input[name="skill_level[]"]:checked').map(function() {
                        return $(this).val();
                    }).get(),
                    search: $('input[name="search"]').val(),
                };
            }

            function showSkeletonLoading(jobCount = 5) {
                let skeletonHTML = '<div class="skeleton-loading">';
                let rows = Math.max(jobCount, 5);
                for (let i = 0; i < rows; i++) {
                    skeletonHTML += `
                    <div class="skeleton-loading">
                        <div class="skeleton-line"></div>
                        <div class="skeleton-line"></div>
                        <div class="skeleton-line"></div>
                        <div class="skeleton-line"></div>
                        <div class="skeleton-line"></div>
                        <div class="skeleton-line"></div>
                    </div> `;
                }
                skeletonHTML += '</div>';
                $('.job-category-body__content').html(skeletonHTML);
            }

            function fetchJobs(page = null) {
                let filters = getFilters();
                if (page) {
                    filters.page = page;
                }

                $.ajax({
                    url: "<?php echo e(route('freelance.filter.jobs')); ?>",
                    method: "GET",
                    data: filters,
                    beforeSend: function() {
                        showSkeletonLoading(filters.jobCount || 5);
                    },
                    success: function(response) {
                        $('.job-category-body__content').fadeOut(300, function() {
                            $(this).html(response.data.html).fadeIn(300);
                        });
                    },
                    error: function(xhr, status, error) {
                        $('.job-category-body__content').html(
                            `<div class="text-center py-5 text-danger">Failed to load data. Please try again.</div>`
                        );
                    }
                });
            }

            let delayTimer;
            $('.filter-block__list input, .search-container input').on('change keyup', function() {
                clearTimeout(delayTimer);
                delayTimer = setTimeout(function() {
                    fetchJobs();
                }, 500);
            });

            $(document).on('click', '.pagination a', function(e) {
                e.preventDefault();
                let page = $(this).attr('href').split('page=')[1];
                fetchJobs(page);
            });
        });
    </script>
<?php $__env->stopPush(); ?>


<?php $__env->startPush('style'); ?>
    <style>
        .job-category-wrapper .job-category-body__content:has(.pagination) .d-none.flex-sm-fill.d-sm-flex.align-items-sm-center.justify-content-sm-between {
            padding: 20px;
        }

        .job-category-wrapper .job-category-body__content .pagination {
            border: 1px solid hsl(var(--black)/.1);
        }

        .job-category-body__content {
            transition: opacity 0.5s ease-in-out;
        }

        .skeleton-loading {
            padding: 20px;
        }

        .skeleton-line {
            height: 20px;
            background: #e0e0e0;
            margin-bottom: 10px;
            border-radius: 4px;
            animation: pulse 1.5s infinite;
        }

        @keyframes pulse {
            0% {
                opacity: 0.6;
            }

            50% {
                opacity: 1;
            }

            100% {
                opacity: 0.6;
            }
        }

        .job-category-body__content {
            transition: opacity 0.5s ease-in-out;
        }

        .fade-out {
            opacity: 0;
        }

        .fade-in {
            opacity: 1;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('Template::layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/joinvegk/brandmasters.pro/core/resources/views/templates/basic/job_explore/jobs.blade.php ENDPATH**/ ?>