<?php
    $content = getContent('facility.content', true)->data_values;
    $facilityElement = getContent('facility.element', false, 4, true);
?>

<div class="facility-section my-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="section-heading two">
                    <h2 class="section-heading__title s-highlight" data-s-break="1" data-s-length="1">
                        <?php echo e(__(@$content->heading)); ?></h2>
                    <p class="section-heading__desc"><?php echo e(__(@$content->subheading)); ?></p>
                </div>
            </div>
        </div>
        <div class="row gy-4 align-items-center">
            <div class="col-lg-6 pe-lg-5">
                <div class="facility-wrapper">
                    <?php $__empty_1 = true; $__currentLoopData = $facilityElement; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $facility): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="facility-item">
                            <h5 class="facility-item__title">
                                <span class="facility-item__icon"> <i class="las la-check"></i> </span>
                                <?php echo e(__(@$facility->data_values->title)); ?>

                            </h5>
                            <p class="facility-item__desc">
                                <?php echo e(__(@$facility->data_values->content)); ?>

                            </p>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <?php echo $__env->make('Template::partials.empty', ['message' => 'Facilities not found!'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-lg-6 ps-lg-5">
                <div class="facility-thumb">
                    <img src="<?php echo e(frontendImage('facility', @$content->image, '1200x1200')); ?>" alt="">
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/joinvegk/brandmasters.pro/core/resources/views/templates/basic/sections/facility.blade.php ENDPATH**/ ?>