
    <?php
        $banner = getContent('banner.content', true)->data_values;
        $clientElement = getContent('client.element', false, null, true);
    ?>

    <section class="banner-section">
        <div class="banner-section__shape">
            <img src="<?php echo e(frontendImage('banner', @$banner->shape, '475x630')); ?>" alt="">
        </div>
        <div class="container">
            <div class="row gy-5 align-items-start">
                <div class="col-lg-6">
                    <div class="banner-content highlight">
                        <h1 class="banner-content__title s-highlight" data-s-break="-1" data-s-length="1">
                            <?php echo e(__(@$banner->heading)); ?></h1>
                        <p class="banner-content__desc"><?php echo e(__(@$banner->subheading)); ?></p>
                    </div>
                    <form id="dynamic-route" action="<?php echo e(route('freelance.jobs')); ?>" method="GET">
                        <div class="search-container">
                            <input type="search" name="search" class="form--control" placeholder="<?php echo app('translator')->get('Type job keyword'); ?>">
                            <div class="banner-search-select">
                                <select class="form-select form--control select2" data-minimum-results-for-search="-1" id="target-area">
                                    <option value="1" data-redirect="<?php echo e(route('freelance.jobs')); ?>" selected><?php echo app('translator')->get('Job'); ?></option>
                                    <option value="2" data-redirect="<?php echo e(route('all.freelancers')); ?>"><?php echo app('translator')->get('Talent'); ?></option>
                                </select>
                            </div>
                            <button class="icon" type="submit">
                                <span class="search-icon"><i class="las la-search"></i></span><small class="search-text"><?php echo app('translator')->get('Search'); ?></small>
                            </button>
                        </div>
                    </form>

                    <div class="buyer-wrapper">
                        <span class="buyer-wrapper__title"><?php echo e(__(@$banner->subtitle)); ?></span>
                        <div class="brand-slider">
                            <?php $__currentLoopData = $clientElement; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <img src= "<?php echo e(frontendImage('client', @$client->data_values->image, '290x100')); ?>"
                                    alt="">
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 d-xsm-block d-none">
                    <div class="banner-thumb-wrapper">
                        <div class="banner-thumb">
                            <img src="<?php echo e(frontendImage('banner', @$banner->image, '1140x970')); ?>" alt="">
                        </div>
                        <div class="banner-thumb-wrapper__content">
                            <div class="banner-thumb-wrapper__item one">
                                <?php echo e(__(@$banner->feature_one)); ?>

                            </div>
                            <div class="banner-thumb-wrapper__item two">
                                <?php echo e(__(@$banner->feature_two)); ?>

                            </div>
                            <div class="banner-thumb-wrapper__item three">
                                <span class="icon">
                                    <img src="<?php echo e(asset($activeTemplateTrue . 'shape/heart.png')); ?>" alt="">
                                </span>
                                <div class="content">
                                    <span class="text"> <?php echo e(__(@$banner->feature_three)); ?></span>
                                    <ul class="rating-list">
                                        <li class="rating-list__item"> <i class="las la-star"></i> </li>
                                        <li class="rating-list__item"> <i class="las la-star"></i> </li>
                                        <li class="rating-list__item"> <i class="las la-star"></i> </li>
                                        <li class="rating-list__item"> <i class="las la-star"></i> </li>
                                        <li class="rating-list__item"> <i class="las la-star"></i> </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="banner-thumb-shape">
                            <span class="banner-thumb-shape__one"></span>
                            <span class="banner-thumb-shape__two"></span>
                            <span class="banner-thumb-shape__three"></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

   
<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/global/js/select2.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style-lib'); ?>
    <link href="<?php echo e(asset('assets/global/css/select2.min.css')); ?>" rel="stylesheet">
<?php $__env->stopPush(); ?>


<?php /**PATH /home/joinvegk/brandmasters.pro/core/resources/views/templates/basic/partials/banner.blade.php ENDPATH**/ ?>