<?php
    $content = getContent('find_task.content', true)->data_values;
    $taskElement = getContent('find_task.element', false, 4, true);
?>

<div class="work-section my-120">
    <div class="container">
        <div class="work-container">
            <div class="work-container__content highlight">
                <h5 class="work-container__subtitle"> <?php echo e(__(@$content->subtitle)); ?> </h5>
                <h2 class="work-container__title s-highlight" data-s-break="-2" data-s-length="2">
                    <?php echo e(__(@$content->heading)); ?> </h2>
                <p class="work-container__desc"> <?php echo e(__(@$content->subheading)); ?> </p>
                <ul class="list">
                    <?php $__empty_1 = true; $__currentLoopData = $taskElement; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <li class="list-item"> <?php echo e(__(@$item->data_values->find_step)); ?> </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="d-flex flex-column justify-content-start align-items-start ">
                            <div class="text-center">
                                <img src="<?php echo e(asset($activeTemplateTrue . 'images/empty.png')); ?>" alt="empty"
                                    class="img-fluid">
                                <h6 class="text-white mt-3"><?php echo app('translator')->get('Choose us data not found'); ?></h6>
                            </div>
                        </div>
                    <?php endif; ?>
                </ul>
                <a href="<?php echo e(route('freelance.jobs')); ?>" class="btn btn--base btn--lg">
                    <?php echo e(__(@$content->button_name)); ?></a>
            </div>
            <div class="work-container__thumb">
                <img src="<?php echo e(frontendImage('find_task', @$content->image, '510x780')); ?>" alt="">
            </div>
            <div class="work-container__shape">
                <img src="<?php echo e(frontendImage('find_task', @$content->shape, '190x420')); ?>" alt="">
            </div>
        </div>
    </div>
</div>
<?php /**PATH D:\laragon\www\update\olance-1.1\Files\core\resources\views/templates/basic/sections/find_task.blade.php ENDPATH**/ ?>