<?php
    $support = getContent('support.content', true)->data_values;
    $content = getContent('brand.content', true)->data_values;
    $brandElement = getContent('brand.element', false, null, true);
?>
<div class="support-section my-120">
    <div class="container">
        <div class="support-wrapper">
            <div class="support-wrapper__left">
                <h6 class="title"><?php echo e(__(@$content->heading)); ?></h6>
                <div class="company-list">
                    <?php $__currentLoopData = $brandElement; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="company-name">
                            <div class="thumb">
                                <img src="<?php echo e(frontendImage('brand', @$brand->data_values->image, '260x60')); ?>"
                                    alt="">
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <div class="support-wrapper__right">
                <div class="support-content">
                    <h4 class="support-content__title"><?php echo e(__(@$support->heading)); ?></h4>
                    <p class="support-item">
                        <span class="support-item__icon"> <i class="las fa-phone"></i> </span>
                        <?php echo app('translator')->get('Hot Line'); ?>: <?php echo e(@$support->hotline_number); ?>

                    </p>
                    <p class="support-item">
                        <span class="support-item__icon"> <i class="las la-paper-plane"></i> </span>
                        <?php echo app('translator')->get('Email'); ?>: <?php echo e(@$support->hotline_email); ?>

                    </p>
                </div>
                <div class="support-wrapper__shape">
                    <img src="<?php echo e(frontendImage('support',@$support->shape , '550x600')); ?>" alt="">
                </div>
                <div class="support-wrapper__thumb">
                    <img src="<?php echo e(frontendImage('support',@$support->image , '275x300')); ?>" alt="">
                </div>
                
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/joinvegk/brandmasters.pro/core/resources/views/templates/basic/sections/support.blade.php ENDPATH**/ ?>