<?php $__env->startSection('content'); ?>
    <?php
        $socialIcons = getContent('social_icon.element', orderById: true);
        $contact = getContent('contact_us.content', true)->data_values;
    ?>

    <div class="contact-section  mb-120">
        <div class="container">
            <div class="row gy-4 justify-content-between align-items-center flex-wrap-reverse">
                <div class="col-xl-4">
                    <div class="contact-item-wrapper">
                        <h5 class="contact-item-wrapper__title"><?php echo e(__(@$contact->title)); ?></h5>
                        <div>
                            <div class="contact-item">
                                <span class="contact-item__icon">
                                    <i class="fa-solid fa-house-user"></i>
                                </span>
                                <div class="contact-item__content">
                                    <p class="contact-item__title"><?php echo app('translator')->get(' Office Address'); ?> </p>
                                    <p class="contact-item__desc">
                                        <?php echo e(__(@$contact->contact_details)); ?>

                                    </p>
                                </div>
                            </div>
                            <div class="contact-item">
                                <span class="contact-item__icon">
                                    <i class="fa-solid fa-paper-plane"></i>
                                </span>
                                <div class="contact-item__content">
                                    <p class="contact-item__title"> <?php echo app('translator')->get('Email Address'); ?> </p>
                                    <p class="contact-item__desc">
                                        <a href="mailto:<?php echo e(@$contact->email_address); ?>" title="<?php echo app('translator')->get('E-mail us'); ?>" class="link"><?php echo e(__(@$contact->email_address)); ?></a>
                                    </p>
                                </div>
                            </div>
                            <div class="contact-item">
                                <span class="contact-item__icon">
                                    <i class="fa-solid fa-phone-volume"></i>
                                </span>
                                <div class="contact-item__content">
                                    <p class="contact-item__title"> <?php echo app('translator')->get('Phone Number'); ?> </p>
                                    <p class="contact-item__desc">
                                        <a href="tel:<?php echo e(@$contact->contact_number); ?>" title="<?php echo app('translator')->get('Call Us'); ?>" class="link"><?php echo e(__(@$contact->contact_number)); ?></a>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="contact-item-wrapper__bottom">
                            <div class="social-list-wrapper">
                                <p class="title"> Follow Us </p>
                                <ul class="social-list">
                                    <?php $__currentLoopData = $socialIcons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="social-list__item"><a href="<?php echo e(@$social->data_values->url); ?>" target="_blank"
                                                title="<?php echo e(__(@$social->data_values->title)); ?>"
                                                class="social-list__link flex-center"><?php echo $social->data_values->social_icon ?></a> </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-7">
                    <div class="contact-form-wrapper">
                        <h4 class="contact-form-wrapper__title"><?php echo e(__(@$contact->heading)); ?></h4>
                        <p class="contact-form-wrapper__desc"><?php echo e(__(@$contact->subheading)); ?>

                        </p>
                        <form method="post" class="verify-gcaptcha verify-form">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-sm-6 form-group">
                                    <label class="form--label"><?php echo app('translator')->get('Name'); ?></label>
                                    <input name="name" type="text" class="form-control form--control"
                                        value="<?php echo e(old('name', @$user->fullname)); ?>"
                                        <?php if($user && $user->profile_complete): ?> readonly <?php endif; ?> required>
                                </div>
                                <div class="col-sm-6 form-group">
                                    <label class="form--label"><?php echo app('translator')->get('Email'); ?></label>
                                    <input name="email" type="email" class="form-control form--control"
                                        value="<?php echo e(old('email', @$user->email)); ?>" <?php if($user): ?> readonly <?php endif; ?>
                                        required>
                                </div>
                                <div class="col-sm-12 form-group">
                                    <label class="form--label"><?php echo app('translator')->get('Subject'); ?></label>
                                    <input name="subject" type="text" class="form-control form--control"
                                        value="<?php echo e(old('subject')); ?>" required>
                                </div>
                                <div class="col-sm-12 form-group">
                                    <label class="form--label"><?php echo app('translator')->get('Message'); ?></label>
                                    <textarea name="message" class="form-control form--control" required><?php echo e(old('message')); ?></textarea>
                                </div>
                                <?php if (isset($component)) { $__componentOriginalff0a9fdc5428085522b49c68070c11d6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalff0a9fdc5428085522b49c68070c11d6 = $attributes; } ?>
<?php $component = App\View\Components\Captcha::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('captcha'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Captcha::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $attributes = $__attributesOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $component = $__componentOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__componentOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>
                                <div class="form-group">
                                    <button type="submit" class="btn btn--base w-100"><?php echo app('translator')->get('Send Message'); ?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        
    </div>

    <?php if(@$sections->secs != null): ?>
        <?php $__currentLoopData = json_decode($sections->secs); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php echo $__env->make($activeTemplate . 'sections.' . $sec, array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .contact-section .social-list__link {
            width: 38px;
            height: 38px;
            color: hsl(var(--base));
            font-size: 14px;
            border: 1px solid hsl(var(--base));
            background-color: hsl(var(--white) / 0.15) !important;
        }
        .contact-section .social-list__link:hover {
            
            color: hsl(var(--white)) !important;
            background-color: hsl(var(--base)) !important;
        }
    </style>
<?php $__env->stopPush(); ?>


<?php echo $__env->make($activeTemplate . 'layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/joinvegk/brandmasters.pro/core/resources/views/templates/basic/contact.blade.php ENDPATH**/ ?>