

<div class="freelancer-item">
    <?php if($freelancer->badge): ?>
        <span class="freelancer-item__status text--base fs-12">
            <i class="las la-award"></i> <?php echo e(__($freelancer->badge->badge_name)); ?>

        </span>
    <?php endif; ?>

    <div class="freelancer-item__thumb">
        <img src="<?php echo e(getImage(getFilepath('userProfile') . '/' . $freelancer->image, avatar: true)); ?>" alt="<?php echo e(__($freelancer->fullname)); ?>">
    </div>

    <div class="freelancer-item__content">
        <h6 class="freelancer-item__name"> <?php echo e(__($freelancer->fullname)); ?></h6>
        <span class="freelancer-item__designation">
            <?php echo e(strLimit(__($freelancer->tagline), 30)); ?>

        </span>

      <?php if($freelancer->avg_rating > 0): ?> 
          <ul class="text-list review-rating-list mb-0">
              <?php for($i = 0; $i < min($freelancer->avg_rating, 5); $i++): ?>
                  <li class="review-rating-list__item"> <i class="las la-star"></i> </li>
              <?php endfor; ?>
  
              <li class="text-list__item">
                  <?php echo e($freelancer->avg_rating); ?>/5
              </li>
          </ul>
  
      <?php endif; ?>
        <ul class="skill-list">
            <?php $__currentLoopData = $freelancer->skills; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $skill): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="skill-list__item">
                    <span class="skill-list__link"><?php echo e(__($skill->name)); ?></span>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>

        <div class="freelancer-item__btn">
            <a href="<?php echo e(route('talent.explore', $freelancer->username)); ?>" class="btn--base btn btn--sm">
                <?php echo app('translator')->get('View Profile'); ?>
            </a>
        </div>
    </div>
</div>


<?php /**PATH D:\laragon\www\update\olance-1.1\Files\core\resources\views/templates/basic/partials/freelancer.blade.php ENDPATH**/ ?>