<?php
    $user = auth()->user();
?>
<div class="sidebar-menu flex-between">
    <div class="sidebar-menu__inner">
        <span class="sidebar-menu__close d-lg-none d-block"><i class="fas fa-times"></i></span>
        <!-- Sidebar Logo Start -->
        <div class="sidebar-logo">
            <a href="<?php echo e(route('home')); ?>" class="sidebar-logo__link"><img src="<?php echo e(siteLogo('dark')); ?>" alt=""></a>
        </div>
        <!-- Sidebar Logo End -->
        <div class="sidebar-menu__top">
            <div class="shape">
                <img src="<?php echo e(asset($activeTemplateTrue . 'shape/d-shape.png')); ?>" alt="">
            </div>
            <span class="icon">
                <i class="las la-wallet"></i>
            </span>
            <div class="content">
                <span class="title"><?php echo app('translator')->get('Balance'); ?></span>
                <h6 class="number"><?php echo e(showAmount(@$user->balance)); ?></h6>
            </div>
         </div>
        <!-- ========= Sidebar Menu Start ================ -->
        <ul class="sidebar-menu-list">
            <li class="sidebar-menu-list__item <?php echo e(menuActive('user.home')); ?>">
                <a href="<?php echo e(route('user.home')); ?>" class="sidebar-menu-list__link">
                    <span class="icon"> <i class="las la-home"></i> </span>
                    <span class="text"><?php echo app('translator')->get('Dashboard'); ?> </span>
                </a>
            </li>
            <li class="sidebar-menu-list__item <?php echo e(menuActive('user.bid.index')); ?>">
                <a href="<?php echo e(route('user.bid.index')); ?>" class="sidebar-menu-list__link">
                    <span class="icon"><i class="las la-gavel"></i></span>
                    <span class="text"><?php echo app('translator')->get('All Bids'); ?> </span>
                </a>
            </li>
            <li
                class="sidebar-menu-list__item <?php echo e(menuActive(['user.project.index', 'user.project.form', 'user.project.detail'])); ?>">
                <a href="<?php echo e(route('user.project.index')); ?>" class="sidebar-menu-list__link">
                    <span class="icon"><i class="las la-briefcase"></i></span>
                    <span class="text"><?php echo app('translator')->get('My Projects'); ?> </span>
                </a>
            </li>
            <li
                class="sidebar-menu-list__item <?php echo e(menuActive(['user.withdraw', 'user.withdraw.history'])); ?> has-dropdown">
                <a href="javascript:void(0)" class="sidebar-menu-list__link">
                    <span class="icon"><i class="las la-money-check-alt"></i></span>
                    <span class="text"> <?php echo app('translator')->get('Withdraw'); ?> </span>
                </a>
                <div class="sidebar-submenu">
                    <ul class="sidebar-submenu-list">
                        <li class="sidebar-submenu-list__item <?php echo e(menuActive('user.withdraw')); ?>">
                            <a href="<?php echo e(route('user.withdraw')); ?>" class="sidebar-submenu-list__link">
                                <span class="text"><?php echo app('translator')->get('Withdraw Money'); ?> </span>
                            </a>
                        </li>
                        <li class="sidebar-submenu-list__item <?php echo e(menuActive('user.withdraw.history')); ?>">
                            <a href="<?php echo e(route('user.withdraw.history')); ?>" class="sidebar-submenu-list__link">
                                <span class="text"><?php echo app('translator')->get('Withdraw Log'); ?> </span>
                            </a>
                        </li>
                    </ul>
                </div>
            </li>

            <li class="sidebar-menu-list__item <?php echo e(menuActive('user.transactions')); ?>">
                <a href="<?php echo e(route('user.transactions')); ?>" class="sidebar-menu-list__link">
                    <span class="icon"><i class="las la-exchange-alt"></i> </span>
                    <span class="text"><?php echo app('translator')->get('Transactions'); ?> </span>
                </a>
            </li>
            <li
                class="sidebar-menu-list__item <?php echo e(menuActive(['ticket.open', 'ticket.index', 'ticket.view'])); ?> has-dropdown">
                <a href="javascript:void(0)" class="sidebar-menu-list__link">
                    <span class="icon"><i class="las la-ticket-alt"></i></span>
                    <span class="text"> <?php echo app('translator')->get('Support Ticket'); ?> </span>
                </a>
                <div class="sidebar-submenu">
                    <ul class="sidebar-submenu-list">
                        <li class="sidebar-submenu-list__item <?php echo e(menuActive('ticket.open')); ?>">
                            <a href="<?php echo e(route('ticket.open')); ?>" class="sidebar-submenu-list__link">
                                <span class="text"><?php echo app('translator')->get('Create New'); ?></span>
                            </a>
                        </li>
                        <li class="sidebar-submenu-list__item <?php echo e(menuActive('ticket.index')); ?>">
                            <a href="<?php echo e(route('ticket.index')); ?>" class="sidebar-submenu-list__link">
                                <span class="text"><?php echo app('translator')->get('Ticket History'); ?> </span>
                            </a>
                        </li>
                    </ul>
                </div>
            </li>

            <li class="sidebar-menu-list__item <?php echo e(menuActive('user.conversation.*')); ?>">
                <a href="<?php echo e(route('user.conversation.index')); ?>" class="sidebar-menu-list__link">
                    <span class="icon"><i class="lab la-rocketchat"></i></span>
                    <span class="text"> <?php echo app('translator')->get('Chat'); ?></span>
                </a>
            </li>

            <li
                class="sidebar-menu-list__item <?php echo e(menuActive(['user.profile.setting', 'user.profile.skill', 'user.profile.education', 'user.profile.portfolio', 'user.change.password', 'user.twofactor'])); ?> has-dropdown">
                <a href="javascript:void(0)" class="sidebar-menu-list__link">
                    <span class="icon"><i class="las la-cog"></i></span>
                    <span class="text"> <?php echo app('translator')->get('Settings'); ?> </span>
                </a>
                <div class="sidebar-submenu">
                    <ul class="sidebar-submenu-list">
                        <li class="sidebar-submenu-list__item <?php echo e(menuActive('user.profile.setting')); ?>">
                            <a href="<?php echo e(route('user.profile.setting')); ?>" class="sidebar-submenu-list__link">
                                <span class="text"><?php echo app('translator')->get('Profile Setting'); ?></span>
                            </a>
                        </li>
                        <li class="sidebar-submenu-list__item <?php echo e(menuActive('user.change.password')); ?>">
                            <a href="<?php echo e(route('user.change.password')); ?>" class="sidebar-submenu-list__link">
                                <span class="text"><?php echo app('translator')->get('Change Password'); ?></span>
                            </a>
                        </li>
                        <li class="sidebar-submenu-list__item <?php echo e(menuActive('user.twofactor')); ?>">
                            <a href="<?php echo e(route('user.twofactor')); ?>" class="sidebar-submenu-list__link">
                                <span class="text"><?php echo app('translator')->get('2FA Security'); ?> </span>
                            </a>
                        </li>
                    </ul>
                </div>
            </li>
            <li class="sidebar-menu-list__item">
                <a href="<?php echo e(route('user.logout')); ?>" class="sidebar-menu-list__link">
                    <span class="icon"><i class="las la-sign-out-alt"></i></span>
                    <span class="text"><?php echo app('translator')->get('Logout'); ?></span>
                </a>
            </li>
        </ul>
        <!-- ========= Sidebar Menu End ================ -->
    </div>
</div>
<?php /**PATH D:\laragon\www\update\olance-1.1\Files\core\resources\views/templates/basic/partials/sidebar.blade.php ENDPATH**/ ?>