<?php
    $content = getContent('subscribe.content', true)->data_values;
?>

<div class="subscribe-section pt-120">
    <div class="container">
        <div class="subscribe-wrapper highlight">
            <div class="subscribe-wrapper__shape">
                <img src="<?php echo e(frontendImage('subscribe', @$content->shape, '130x290')); ?>" alt="">
            </div>
            <div class="subscribe-content">
                <span class="subscribe-content__shape">
                    <img src="<?php echo e(asset($activeTemplateTrue . '/shape/subscribe.png')); ?>" alt="">
                </span>
                <h4 class="subscribe-content__title s-highlight" data-s-break="-1" data-s-length="1">
                    <?php echo e(__(@$content->heading)); ?></h4>
                <p class="subscribe-content__text"> <span class="fw-bold"> <?php echo e(__(@$content->subheading)); ?></span></p>
                <form class="subscribe-form">
                    <div class="input-group">
                        <input type="email" class="form-control form--control h-50" required name="email" placeholder="<?php echo app('translator')->get('Enter your email address'); ?>">
                        <button class="input-group-text input-text-style">  <i class="fa-regular fa-paper-plane"></i></button>
                    </div>
                </form>
            </div>
            <div class="subscribe-thumb">
                <img src="<?php echo e(frontendImage('subscribe', @$content->image, '1070x930')); ?>" alt="">
            </div>
        </div>
    </div>
</div>


<?php $__env->startPush('script'); ?>
    <script>
        'use strict';

        $(function() {
            $('.subscribe-form').on('submit', function(event) {
                event.preventDefault();
                var email = $('.subscribe-form').find('[name="email"]').val();
                if (!email) {
                    notify('error', 'Email field is required');
                } else {
                    $.ajax({
                        headers: {
                            "X-CSRF-TOKEN": "<?php echo e(csrf_token()); ?>",
                        },
                        url: "<?php echo e(route('subscribe')); ?>",
                        method: "POST",
                        data: {
                            email: email
                        },
                        success: function(response) {
                            if (response.success) {
                                notify('success', response.message);
                                $('.subscribe-form').find('[name="email"]').val('');
                            } else {
                                notify('error', response.error);
                            }
                        }
                    });
                }
            });

        })
    </script>
<?php $__env->stopPush(); ?><?php /**PATH /home/joinvegk/brandmasters.pro/core/resources/views/templates/basic/sections/subscribe.blade.php ENDPATH**/ ?>