<?php
    $categories = App\Models\Category::active()
        ->where('is_featured', Status::YES)
        ->orderBy('id', 'DESC')
        ->withCount([
            'jobs' => function ($query) {
                $query->published()->approved();
            },
        ])
        ->get();
?>

<?php if($categories->count()): ?>
    <div class="category-section my-120">
        <div class="container">
            <div class="category-slider">
                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div>
                        <a href="<?php echo e(route('freelance.jobs', ['category_id' => $category->id])); ?>" class="category-item">
                            <div class="category-item__thumb">
                                <img src="<?php echo e(getImage(getFilepath('category') . '/' . $category->image, getFileSize('category'))); ?>" alt="">
                            </div>
                            <div class="category-item__content">
                                <h5 class="category-item__title"> <?php echo e(__(@$category->name)); ?> </h5>
                                <p class="category-item__text"> <?php echo e($category->jobs_count); ?> <?php echo app('translator')->get('Job'); ?> </p>
                            </div>
                        </a>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php /**PATH D:\laragon\www\update\olance-1.1\Files\core\resources\views/templates/basic/sections/category.blade.php ENDPATH**/ ?>