<?php
    $content = getContent('faq.content', true)->data_values;
    $faqElement = getContent('faq.element', false, null, true);
?>

<div class="faq-section my-120">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="section-heading two">
                    <h2 class="section-heading__title s-highlight" data-s-break="-2" data-s-length="2">
                        <?php echo e(__(@$content->heading)); ?></h2>
                    <p class="section-heading__desc"> <?php echo e(__(@$content->subheading)); ?> </p>
                </div>
            </div>
        </div>
        <div class="row justify-content-center align-items-center gy-4">
            <div class="col-xxl-7 col-xl-6 pe-xxl-5">
                <div class="accordion accordion-filter custom--accordion" id="accordionExample">
                    <?php $__currentLoopData = $faqElement; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="heading<?php echo e($loop->index + 1); ?>">
                                <button class="accordion-button <?php echo e(!$loop->first ? 'collapsed' : null); ?>" type="button"
                                    data-bs-toggle="collapse" data-bs-target="#faq-<?php echo e($loop->index); ?>"
                                    aria-expanded="<?php echo e(!$loop->first ? 'false' : 'true'); ?>"
                                    aria-controls="faq-<?php echo e($loop->index); ?>">
                                    <span class="accordion-button__number"> <?php echo e($loop->index + 1); ?> </span>
                                    <?php echo e(__(@$item->data_values->question)); ?>

                                </button>
                            </h2>
                            <div id="faq-<?php echo e($loop->index); ?>"
                                class="accordion-collapse collapse <?php echo e($loop->first ? 'show' : null); ?>"
                                aria-labelledby="heading<?php echo e($loop->index + 1); ?>"
                                data-bs-parent="#accordionExample">
                                <div class="accordion-body">
                                    <?php echo e(__(@$item->data_values->answer)); ?>

                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <div class="text-end">
                        <button class="load-more-button"> <?php echo app('translator')->get('Show more'); ?> </button>
                    </div>
                </div>
            </div>
            <div class="col-xxl-5 col-xl-6  d-xl-block d-none">
                <div class="faq-thumb-wrapper">
                    <div class="faq-thumb">
                        <img src="<?php echo e(frontendImage('faq', @$content->image, '840x1140')); ?>" alt="">
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH D:\laragon\www\update\olance-1.1\Files\core\resources\views/templates/basic/sections/faq.blade.php ENDPATH**/ ?>