<?php $__env->startSection('panel'); ?>
    <div class="dashboard position-relative">
        <div class="dashboard__inner flex-wrap">
            <!-- ====================== Sidebar menu Start ========================= -->
            <?php echo $__env->make('Template::partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <!-- ====================== Sidebar menu End ========================= -->
            <?php
                $user = App\Models\User::with('badge')->find(auth()->id());
            ?>

            <div class="dashboard__right">
                <!-- Dashboard Header Start -->
                <div class="dashboard-header">
                    <div class="dashboard-header__inner flex-between">
                        <div class="dashboard-header__left">
                            <div class="dashboard-body__bar d-lg-none d-inline-block">
                                <span class="dashboard-body__bar-icon"><i class="fas fa-bars"></i></span>
                            </div>
                            <h6 class="title"> <?php echo e(__(@$pageTitle)); ?> </h6>
                        </div>
                        <div class="user-info">
                            <div class="user-info__right">
                                <div class="notification">
                                    <a class="notification-link" href="<?php echo e(route('user.conversation.index')); ?>"><i
                                            class="las la-envelope"></i>
                                        <?php if($unreadCount > 0): ?>
                                            <span class="notification-number"><?php echo e($unreadCount); ?></span>
                                        <?php endif; ?>
                                    </a>
                                </div>
                                <?php if($user->badge): ?>
                                    <div class="user-info__button">
                                        <div class="user-info__thumb">
                                            <div class="user-info__button">
                                                <div class="user-info__thumb">
                                                    <div class="profile-badge">
                                                        <img data-bs-toggle="tooltip" title="<?php echo e($user->badge->badge_name); ?>"
                                                            src="<?php echo e(getImage(getFilePath('badge') . '/' . $user->badge->image, getFileSize('badge'))); ?>"
                                                            alt="">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <div class="user-info__button">
                                    <div class="user-info__thumb">
                                        <img src="<?php echo e(getImage(getFilePath('userProfile') . '/' . $user->image, avatar: true)); ?>"
                                            alt="">
                                    </div>
                                </div>
                            </div>
                            <ul class="user-info-dropdown">
                                <div class="profile-icon mb-2">
                                    <div class="name"><?php echo e(strLimit($user->fullname)); ?></div>
                                    <div class="role"><?php echo app('translator')->get('Freelancer'); ?></div>
                                </div>
                                <li class="user-info-dropdown__item">
                                    <a class="user-info-dropdown__link" href="<?php echo e(route('user.profile.setting')); ?>">
                                        <span class="icon"><i class="fas fa-user-circle"></i></span>
                                        <span class="text"><?php echo app('translator')->get('My Profile'); ?></span>
                                    </a>
                                </li>
                                <li class="user-info-dropdown__item">
                                    <a class="user-info-dropdown__link" href="<?php echo e(route('user.change.password')); ?>">
                                        <span class="icon"><i class="fas fa-lock"></i></span>
                                        <span class="text"><?php echo app('translator')->get('Password'); ?></span>
                                    </a>
                                </li>
                                <li class="user-info-dropdown__item">
                                    <a class="user-info-dropdown__link" href="<?php echo e(route('user.twofactor')); ?>">
                                        <span class="icon"><i class="fas fa-key"></i></span>
                                        <span class="text"><?php echo app('translator')->get('2FA Security'); ?></span>
                                    </a>
                                </li>
                                <li class="user-info-dropdown__item">
                                    <a class="user-info-dropdown__link" href="<?php echo e(route('user.logout')); ?>">
                                        <span class="icon"><i class="fas fa-cog"></i></span>
                                        <span class="text"><?php echo app('translator')->get('Logout'); ?></span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <!-- Dashboard Header End -->

                <!-- Dashboard Body End -->
                <div class="dashboard-body">


                    <?php echo $__env->yieldContent('content'); ?>

                </div>
                <!-- Dashboard Body End -->
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laragon\www\update\olance-1.1\Files\core\resources\views/templates/basic/layouts/master.blade.php ENDPATH**/ ?>