<?php
    $content = getContent('blog.content', true)->data_values;
    $blogElement = getContent('blog.element', false, 6);
?>

<section class="blog my-120">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="section-heading two">
                    <h2 class="section-heading__title s-highlight" data-s-break="-2" data-s-length="2">
                        <?php echo e(__(@$content->heading)); ?></h2>
                    <p class="section-heading__desc"><?php echo e(__(@$content->subheading)); ?></p>
                </div>
            </div>
        </div>
        <div class="row gy-4 justify-content-center">
            <?php $__currentLoopData = $blogElement ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xl-4 col-sm-6">
                    <a href="<?php echo e(route('blog.details', $blog->slug)); ?>" class="blog-item">
                        <div class="blog-item__thumb">
                            <img src="<?php echo e(frontendImage('blog', 'thumb_' . @$blog->data_values->image, '485x300')); ?>" class="fit-image" alt="">
                        </div>
                        <div class="blog-item__content">
                            <h6 class="blog-item__title">
                                <?php echo e(__(strLimit(@$blog->data_values->title, 80))); ?>

                            </h6>
                            <ul class="text-list flex-align">
                                <li class="text-list__item">
                                    <?php echo e(showDateTime($blog->created_at, 'd M, Y')); ?>

                                </li>
                            </ul>
                        </div>
                    </a>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php /**PATH D:\laragon\www\update\olance-1.1\Files\core\resources\views/templates/basic/sections/blog.blade.php ENDPATH**/ ?>