<?php
    use App\Models\Language;
    $languages = Language::get();
    $defaultLang = $languages->firstWhere('is_default', Status::YES);
    $currentLangCode = session('lang', config('app.locale'));
    $currentLang = $languages->firstWhere('code', $currentLangCode) ?: $defaultLang;
?>

<header class="header" id="header">
    <div class="container">
        <nav class="navbar navbar-expand-xl navbar-light">
            <a class="navbar-brand logo" href="<?php echo e(route('home')); ?>"><img src="<?php echo e(siteLogo()); ?>" alt=""></a>
            <div class="d-xl-none d-block job-link">
                <a href="<?php echo e(route('buyer.job.post.form')); ?>" class="btn btn--base btn--sm">
                    <?php echo app('translator')->get('Post Job'); ?>
                </a>
            </div>

            <button class="navbar-toggler header-button" type="button" data-bs-toggle="collapse"
                data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false"
                aria-label="Toggle navigation">
                <span id="hiddenNav"><i class="las la-bars"></i></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav nav-menu me-auto align-items-xl-center">
                    <li class="nav-item <?php echo e(menuActive('home')); ?>">
                        <a class="nav-link" aria-current="page" href="<?php echo e(route('home')); ?>"> <?php echo app('translator')->get('Home'); ?> </a>
                    </li>
                    <?php if(count($pages) > 1): ?>
                        <li class="nav-item dropdown">
                            <a class="nav-link" href="javascript:void(0)" role="button" data-bs-toggle="dropdown"
                                aria-expanded="false">
                                <?php echo app('translator')->get('Pages'); ?> <span class="nav-item__icon"><i class="las la-angle-down"></i></span>
                            </a>
                            <ul class="dropdown-menu">
                                <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="dropdown-menu__list <?php echo e(menuActive('pages', null, @$data->slug)); ?>">
                                        <a class="dropdown-item dropdown-menu__link"
                                            href="<?php echo e(route('pages', $data->slug)); ?>">
                                            <?php echo e(__($data->name)); ?>

                                        </a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </li>
                    <?php else: ?>
                        <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="nav-item <?php echo e(menuActive('pages', null, @$data->slug)); ?>">
                                <a class="nav-link" href="<?php echo e(route('pages', $data->slug)); ?>"><?php echo e(__($data->name)); ?></a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>

                    <li class="nav-item <?php echo e(menuActive(['freelance.jobs', 'explore.bid.job'])); ?>">
                        <a class="nav-link " href="<?php echo e(route('freelance.jobs')); ?>"> <?php echo app('translator')->get('Find Jobs'); ?> </a>
                    </li>
                    <li class="nav-item <?php echo e(menuActive(['all.freelancers', 'talent.explore'])); ?>">
                        <a class="nav-link" href="<?php echo e(route('all.freelancers')); ?>"> <?php echo app('translator')->get('Find Talents'); ?> </a>
                    </li>

                    <li class="nav-item <?php echo e(menuActive(['blogs', 'blog.details'])); ?>">
                        <a class="nav-link" href="<?php echo e(route('blogs')); ?>"><?php echo app('translator')->get('Blogs'); ?> </a>
                    </li>
                    <li class="nav-item <?php echo e(menuActive('contact')); ?>">
                        <a class="nav-link" href="<?php echo e(route('contact')); ?>"><?php echo app('translator')->get('Contact'); ?> </a>
                    </li>
                    <li class="nav-item d-flex justify-content-between w-100 d-xl-none">
                        <div class="top-button w-100">
                            <ul class="login-registration-list d-flex flex-wrap justify-content-between align-items-center">
                                <li class="login-registration-list__item d-flex gap-3">
                                    <?php if(auth()->guard()->check()): ?>
                                        <a href="<?php echo e(route('user.home')); ?>" class="login-registration-list__link">
                                            <?php echo app('translator')->get('Dashboard'); ?> </a>
                                    <?php else: ?>
                                        <?php if(auth()->guard('buyer')->check()): ?>
                                            <a href="<?php echo e(route('buyer.home')); ?>" class="login-registration-list__link">
                                                <?php echo app('translator')->get('Dashboard'); ?> </a>
                                        <?php else: ?>
                                            <a href="<?php echo e(route('user.login')); ?>" class="login-registration-list__link">
                                                <?php echo app('translator')->get('Login'); ?> </a>
                                            <a href="<?php echo e(route('user.register')); ?>" class="login-registration-list__link">
                                                <?php echo app('translator')->get('Register'); ?> </a>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </li>
                                <li class="login-registration-list__item">
                                    <?php if(gs('multi_language')): ?>
                                        <?php echo $__env->make('Template::partials.language', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                                    <?php endif; ?>
                                </li>
                            </ul>
                        </div>

                    </li>
                </ul>
            </div>
            <div class="d-xl-block d-none">
                <div class="top-button d-flex flex-wrap justify-content-between align-items-center">

                    <?php if(gs('multi_language')): ?>
                        <?php echo $__env->make('Template::partials.language', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    <?php endif; ?>

                    <ul class="login-registration-list d-flex flex-wrap justify-content-between align-items-center">
                        <?php if(auth()->guard()->check()): ?>
                            <li class="login-registration-list__item">
                                <a href="<?php echo e(route('user.home')); ?>" class="login-registration-list__link">
                                    <?php echo app('translator')->get('Dashboard'); ?> </a>
                            </li>
                        <?php else: ?>
                            <?php if(auth()->guard('buyer')->check()): ?>
                                <li class="login-registration-list__item">
                                    <a href="<?php echo e(route('buyer.home')); ?>" class="login-registration-list__link">
                                        <?php echo app('translator')->get('Dashboard'); ?> </a>
                                </li>
                            <?php else: ?>
                                <li class="login-registration-list__item">
                                    <a href="<?php echo e(route('user.login')); ?>" class="login-registration-list__link">
                                        <?php echo app('translator')->get('Login'); ?>
                                    </a>
                                </li>
                                <li class="login-registration-list__item">
                                    <a href="<?php echo e(route('user.register')); ?>" class="login-registration-list__link">
                                        <?php echo app('translator')->get('Register'); ?> </a>
                                </li>
                            <?php endif; ?>
                        <?php endif; ?>

                        <?php if(!auth()->check()): ?>
                            <li class="login-registration-list__item">
                                <a href="<?php echo e(route('buyer.job.post.form')); ?>" class="btn btn--base"> <?php echo app('translator')->get('Post Job'); ?> </a>
                            </li>
                        <?php endif; ?>
                    </ul>
                    
                </div>
            </div>
        </nav>
    </div>
</header>
<?php /**PATH D:\laragon\www\update\olance-1.1\Files\core\resources\views/templates/basic/partials/header.blade.php ENDPATH**/ ?>