<?php  use Carbon\Carbon; ?>

<?php $__empty_1 = true; $__currentLoopData = $jobs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $job): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
    <div class="expert-developer">
        <div class="expert-developer__top">
            <div class="left">
                <div class="left__top">
                    <h6 class="expert-developer__title">
                        <a href="<?php echo e(route('explore.bid.job', $job->slug)); ?>">
                            <?php echo e(strLimit(__($job->title), 100)); ?>

                        </a>
                    </h6>

                </div>
                <span class="expert-developer__time">
                    <?php echo e(getJobTimeDifference($job->created_at, $job->deadline)); ?>

                </span>
                <div class="job-information-area">
                    <div>
                        <span class="title"> <?php echo app('translator')->get('Budget'); ?> <sup> [<?php if($job->custom_budget): ?>
                                    <?php echo app('translator')->get('Customized'); ?>
                                <?php else: ?>
                                    <?php echo app('translator')->get('Fixed'); ?>
                                <?php endif; ?>] </sup></span>
                        <p class="text"> <?php echo e(showAmount($job->budget)); ?> </p>
                    </div>
                    <div>
                        <span class="title"> <?php echo app('translator')->get('Experience level'); ?> </span>
                        <p class="text">
                            <?php if($job->skill_level == Status::SKILL_PRO): ?>
                                <?php echo app('translator')->get('Pro Level'); ?>
                            <?php elseif($job->skill_level == Status::SKILL_EXPERT): ?>
                                <?php echo app('translator')->get('Expert'); ?>
                            <?php elseif($job->skill_level == Status::SKILL_INTERMEDIATE): ?>
                                <?php echo app('translator')->get('Intermediate'); ?>
                            <?php else: ?>
                                <?php echo app('translator')->get('Entry'); ?>
                            <?php endif; ?>
                        </p>
                    </div>
                </div>
            </div>
            <div class="right">
                <a href="<?php echo e(route('explore.bid.job', $job->slug)); ?>" target="_blank" class="btn btn--base btn--xsm">
                    <?php echo app('translator')->get('Bid Now'); ?>
                </a>
                <p class="total-bid mt-1">
                    <span class="text"> <?php echo app('translator')->get('Bids'); ?>: <?php echo e($job->bids_count); ?> </span>
                </p>
            </div>
        </div>
        <p class="expert-developer__desc">
            <?php echo strLimit(strip_tags($job->description), 230) ?>
        </p>

        <!-- Displaying job skills -->
        <ul class="skill-list justify-content-start">
            <?php $__currentLoopData = $job->skills; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $skill): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="skill-list__item">
                    <a href="javascript:void(0)" class="skill-list__link">
                        <?php echo e(__($skill->name)); ?>

                    </a>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
    <div class="empty-message text-center py-5">
        <img src="<?php echo e(asset($activeTemplateTrue . 'images/empty.png')); ?>" alt="empty">
        <p class="text-muted mt-3"><?php echo app('translator')->get('No job found!'); ?></p>
    </div>
<?php endif; ?>


<?php if($jobs->hasPages()): ?>
    <?php echo e($jobs->links('pagination::bootstrap-5')); ?>

<?php endif; ?>
<?php /**PATH /home/joinvegk/brandmasters.pro/core/resources/views/templates/basic/job_explore/job.blade.php ENDPATH**/ ?>