<?php
    $content = getContent('why_choose.content', true)->data_values;
    $whyChooseElement = getContent('why_choose.element', false, 8, true);
?>

<div class="why-choose-section my-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="section-heading two">
                    <h2 class="section-heading__title s-highlight" data-s-break="-2" data-s-length="2">
                        <?php echo e(__(@$content->heading)); ?> </h2>
                    <p class="section-heading__desc"><?php echo e(@$content->subheading); ?></p>
                </div>
            </div>
        </div>

        <?php if(!blank($whyChooseElement)): ?>
            <div class="choose-wrapper">
                <?php $__currentLoopData = $whyChooseElement; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="choose-item">
                        <span class="choose-item__icon">
                            <img src="<?php echo e(frontendImage('why_choose', @$item->data_values->image, '80x80')); ?>"
                                class="choose us" alt="">
                        </span>
                        <div class="choose-item__content">
                            <h5 class="choose-item__title"> <?php echo e(__(@$item->data_values->title)); ?> </h5>
                            <p class="choose-item__desc"><?php echo e(__(@$item->data_values->content)); ?></p>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php else: ?>
            <div class="d-flex flex-column justify-content-center align-items-center ">
                <div class="text-center">
                    <img src="<?php echo e(asset($activeTemplateTrue . 'images/empty.png')); ?>" alt="empty" class="img-fluid">
                    <h6 class="text-muted mt-3"><?php echo app('translator')->get('Choose us data not found'); ?></h6>
                </div>
            </div>
        <?php endif; ?>

    </div>
</div>
<?php /**PATH /home/joinvegk/brandmasters.pro/core/resources/views/templates/basic/sections/why_choose.blade.php ENDPATH**/ ?>