<?php
    $accountContent = getContent('account.content', true)->data_values;
    $contactContent = getContent('contact_us.content', true)->data_values;
    $policyPages = getContent('policy_pages.element', false, null, true);
    $socialIcons = getContent('social_icon.element', orderById: true);
?>

<footer class="footer-area">
    <div class="container">
        <div class="footer-area__top">
            <div class="sign-up-wrapper highlight">
                <div class="sign-up-content">
                    <h4 class="sign-up-content__title s-highlight" data-s-break="-1" data-s-length="1">
                        <?php echo e(__(@$accountContent->freelancer_title)); ?></h4>
                    <p class="sign-up-content__desc"> <?php echo e(__(@$accountContent->freelancer_content)); ?> </p>
                    <a href="<?php echo e(route('user.register')); ?>" class="sign-up-content__btn btn btn--base">
                        <?php echo e(__(@$accountContent->freelancer_button_name)); ?> </a>
                </div>
                <div class="sign-up-content">
                    <h4 class="sign-up-content__title s-highlight" data-s-break="-1" data-s-length="1">
                        <?php echo e(__(@$accountContent->buyer_title)); ?></h4>
                    <p class="sign-up-content__desc"> <?php echo e(__(@$accountContent->buyer_content)); ?> </p>
                    <a href="<?php echo e(route('buyer.register')); ?>" class="sign-up-content__btn btn btn--base">
                        <?php echo e(__(@$accountContent->buyer_button_name)); ?> </a>
                </div>
            </div>
        </div>
        <div class="footer-wrapper py-60">
            <div class="footer-item">
                <h5 class="footer-item__title"> <?php echo app('translator')->get('Navigation'); ?> </h5>
                <ul class="footer-menu">
                    <li class="footer-menu__item"><a href="<?php echo e(route('home')); ?>" class="footer-menu__link">
                            <?php echo app('translator')->get('Home'); ?> </a></li>
                    <li class="footer-menu__item"><a href="<?php echo e(route('blogs')); ?>" class="footer-menu__link">
                            <?php echo app('translator')->get('Blogs'); ?> </a></li>
                    <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="footer-menu__item <?php echo e(menuActive('pages', null, @$data->slug)); ?>">
                            <a href="<?php echo e(route('pages', $data->slug)); ?>" class="footer-menu__link">
                                <?php echo e(__($data->name)); ?> </a>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <li class="footer-menu__item"><a href="<?php echo e(route('contact')); ?>" class="footer-menu__link"><?php echo app('translator')->get('Contact Us'); ?> </a></li>

                </ul>
            </div>
            <div class="footer-item">
                <h5 class="footer-item__title"> <?php echo app('translator')->get('Important Link'); ?> </h5>
                <ul class="footer-menu">
                    <?php if(auth()->check()): ?>
                        <li class="footer-menu__item"><a href="<?php echo e(route('user.home')); ?>" class="footer-menu__link"> <?php echo app('translator')->get('Dashboard'); ?> </a></li>
                    <?php elseif(auth('buyer')->check()): ?>
                        <li class="footer-menu__item"><a href="<?php echo e(route('buyer.home')); ?>" class="footer-menu__link"> <?php echo app('translator')->get('Dashboard'); ?> </a></li>
                    <?php else: ?>
                        <li class="footer-menu__item"><a href="<?php echo e(route('user.login')); ?>" class="footer-menu__link"> <?php echo app('translator')->get('Login Now'); ?> </a></li>
                    <?php endif; ?>
                    <li class="footer-menu__item"><a href="<?php echo e(route('buyer.job.post.form')); ?>" class="footer-menu__link"> <?php echo app('translator')->get('Post a Job'); ?> </a></li>
                    <li class="footer-menu__item"><a href="<?php echo e(route('freelance.jobs')); ?>" class="footer-menu__link">
                            <?php echo app('translator')->get('Find a Jobs'); ?> </a>
                    </li>
                    <li class="footer-menu__item"><a href="<?php echo e(route('all.freelancers')); ?>" class="footer-menu__link"><?php echo app('translator')->get('Find a Talent'); ?> </a>
                    </li>
                </ul>
            </div>

            <div class="footer-item">
                <h5 class="footer-item__title"> <?php echo app('translator')->get('Terms'); ?> </h5>
                <ul class="footer-menu">
                    <?php $__currentLoopData = $policyPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $policy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="footer-menu__item"><a href="<?php echo e(route('policy.pages', @$policy->slug)); ?>" class="footer-menu__link"><?php echo e(__(@$policy->data_values->title)); ?></a>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <li class="footer-menu__item"><a href="<?php echo e(route('cookie.policy')); ?>" class="footer-menu__link">
                            <?php echo app('translator')->get('Cookie Policy'); ?> </a>
                    </li>
                </ul>
            </div>
            <div class="footer-item">
                <h5 class="footer-item__title"> <?php echo app('translator')->get('Contact Us'); ?></h5>
                <ul class="footer-contact-menu">
                    <li class="footer-contact-menu__item">
                        <div class="footer-contact-menu__item-icon">
                            <i class="fas fa-map-marker-alt"></i>
                        </div>
                        <div class="footer-contact-menu__item-content">
                            <p> <?php echo e(__(@$contactContent->contact_details)); ?></p>
                        </div>
                    </li>
                    <li class="footer-contact-menu__item">
                        <div class="footer-contact-menu__item-icon">
                            <i class="fas fa-phone"></i>
                        </div>
                        <div class="footer-contact-menu__item-content">
                            <a title="<?php echo app('translator')->get('Call us'); ?>" href="tel:<?php echo e(@$contactContent->contact_number); ?>"><?php echo e(__(@$contactContent->contact_number)); ?></a>
                        </div>
                    </li>
                    <li class="footer-contact-menu__item">
                        <div class="footer-contact-menu__item-icon">
                            <i class="fas fa-envelope"></i>
                        </div>
                        <div class="footer-contact-menu__item-content">
                            <a title="<?php echo app('translator')->get('E-mail us'); ?>" href="mailto:<?php echo e(@$contactContent->email_address); ?>"><?php echo e(__(@$contactContent->email_address)); ?></a>
                        </div>
                    </li>
                </ul>
                <div class="social-list-wrapper">
                    <p class="title"><?php echo app('translator')->get('Follow Us'); ?> </p>
                    <ul class="social-list">
                        <?php $__currentLoopData = $socialIcons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="social-list__item"><a href="<?php echo e(@$social->data_values->url); ?>" target="_blank" title="<?php echo e(__(@$social->data_values->title)); ?>" class="social-list__link flex-center"><?php echo $social->data_values->social_icon ?></a> </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- bottom Footer -->
    <div class="bottom-footer py-3">
        <div class="container">
            <div class="row gy-3">
                <div class="col-md-12 text-center">
                    <div class="bottom-footer-text"> <?php echo app('translator')->get('Copyright'); ?> &copy;<?php echo e(date('Y')); ?>

                        <a href="<?php echo e(route('home')); ?>"><?php echo e(__(gs('site_name'))); ?></a> <?php echo app('translator')->get('All rights reserved'); ?> .
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>
<!-- ========
<?php /**PATH /home/joinvegk/brandmasters.academy/core/resources/views/templates/basic/partials/footer.blade.php ENDPATH**/ ?>