<?php $__env->startSection('panel'); ?>
    <?php
        $login = getContent('login.content', true)->data_values;
        $switchingBtn = getContent('switching_button.content', true)->data_values;
        $banner = getContent('banner.content', true)->data_values;
    ?>

    <section class="account">
        <div class="account-inner">
            <div class="account-inner__left">
                <div class="account-inner__shape">
                    <img src="<?php echo e(frontendImage('banner', @$banner->shape, '475x630')); ?>" alt="">
                </div>
                <div class="account-thumb">
                    <img src="<?php echo e(frontendImage('login', @$login->image, '770x670')); ?>" alt="">
                </div>
            </div>
            <div class="account-inner__right">
                <div class="account-form-wrapper">
                    <a href="<?php echo e(route('home')); ?>" class="account-form__logo">
                        <img src="<?php echo e(siteLogo()); ?>" alt="">
                    </a>
                    <form method="POST" action="<?php echo e(route('buyer.login')); ?>" class="verify-gcaptcha">
                        <?php echo csrf_field(); ?>
                        <div class="account-form">
                            <div class="radio-btn-wrapper">
                                <div class="form--radio">
                                    <input class="form-check-input" type="radio" name="apply-wrapper"
                                        id="apply-freelancer" value="1"
                                        <?php if(Route::currentRouteName() == 'user.login'): ?> checked <?php endif; ?>
                                        onclick="window.location='<?php echo e(route('user.login')); ?>'">
                                    <label class="form-check-label" for="apply-freelancer">
                                        <span class="text"><?php echo e(__($switchingBtn->freelancer_login_button)); ?></span>
                                    </label>
                                </div>
                                <div class="form--radio">
                                    <input class="form-check-input" type="radio" name="apply-wrapper" id="apply-buyer"
                                        value="2" <?php if(Route::currentRouteName() == 'buyer.login'): ?> checked <?php endif; ?>
                                        onclick="window.location='<?php echo e(route('buyer.login')); ?>'">
                                    <label class="form-check-label" for="apply-buyer">
                                        <span class="text"><?php echo e(__($switchingBtn->buyer_login_button)); ?> </span>
                                    </label>
                                </div>
                            </div>
                            <p class="text"> <?php echo app('translator')->get('Welcome Back'); ?> </p>
                            <h5 class="account-form__title"> <?php echo e(__(@$login->heading)); ?></h5>

                            <?php echo $__env->make('Template::partials.buyer_social_login', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

                            <div class="row">
                                <div class="col-12">
                                    <div class="form-group">
                                        <label for="username" class="form--label"> <?php echo app('translator')->get('Username or Email'); ?> </label>
                                        <input type="text" name="username" value="<?php echo e(old('username')); ?>"
                                            class="form-control form--control" id="username" required>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-group">
                                        <label for="your-password" class="form--label"><?php echo app('translator')->get('Password'); ?></label>
                                        <div class="position-relative">
                                            <input id="your-password" type="password" name="password"
                                                class="form--control form-control <?php if(gs('secure_password')): ?> secure-password <?php endif; ?>"
                                                autocomplete="off" required>
                                            <span class="password-show-hide fa-solid fa-eye toggle-password"
                                                id="toggle-password" aria-label="Toggle password visibility"></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-group">
                                        <div class="flex-between">
                                            <div class="form--check">
                                                <input class="form-check-input" type="checkbox" name="remember"
                                                    id="flexCheckChecked" <?php echo e(old('remember') ? 'checked' : ''); ?>>
                                                <label class="form-check-label" for="flexCheckChecked">
                                                    <?php echo app('translator')->get('Remember Me'); ?>
                                                </label>
                                            </div>
                                            <a href="<?php echo e(route('buyer.password.request')); ?>" class="forgot-password">
                                                <?php echo app('translator')->get('Forgot password?'); ?> </a>
                                        </div>
                                    </div>
                                </div>

                                <?php if (isset($component)) { $__componentOriginalff0a9fdc5428085522b49c68070c11d6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalff0a9fdc5428085522b49c68070c11d6 = $attributes; } ?>
<?php $component = App\View\Components\Captcha::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('captcha'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Captcha::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $attributes = $__attributesOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $component = $__componentOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__componentOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>

                                <div class="col-12 form-group">
                                    <button type="submit" class="btn btn--base w-100"> <?php echo app('translator')->get('Login Account'); ?> </button>
                                </div>
                            </div>
                            <p class="account-form__text"> <?php echo app('translator')->get('Don\'t have on account yet?'); ?>
                                <a href="<?php echo e(route('buyer.register')); ?>" class="text--base"> <?php echo app('translator')->get('Create Account'); ?> </a>
                            </p>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/joinvegk/brandmasters.pro/core/resources/views/templates/basic/buyer/auth/login.blade.php ENDPATH**/ ?>