<?php
    $content = getContent('top_freelancer.content', true)->data_values;
    $counterElement = getContent('counter.element', false, 3, true);
    $topHundredFreelancers = App\Models\User::active()
        ->orderBy('earning', 'DESC')
        ->orderByDesc('users.avg_rating')
        ->with([
            'projects' => function ($query) {
                $query->where('status', Status::PROJECT_COMPLETED);
            },
            'skills','badge'
        ])
        ->take(100)
        ->get();

?>
<div class="best-freelancer-section py-120 my-120">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="section-heading style-left highlight">
                    <h2 class="section-heading__title s-highlight" data-s-break="-1" data-s-length="1">
                        <?php echo e(__(@$content->heading)); ?></h2>
                    <p class="section-heading__desc"> <?php echo e(__(@$content->subheading)); ?></p>
                </div>
            </div>
        </div>
        
        <?php if($topHundredFreelancers->count()): ?> 
            <div class="best-freelancer">
                <?php $__currentLoopData = $topHundredFreelancers ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $freelancer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo $__env->make($activeTemplate . 'partials.freelancer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>
        <div class="counter-up-wrapper">
            <div class="counterup-item ">
                <?php $__empty_1 = true; $__currentLoopData = $counterElement; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $counter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="counterup-item__content">
                        <div class="counterup-wrapper">
                            <span class="counterup-item__icon">
                                <?php  echo @$counter->data_values->icon; ?>
                            </span>
                            <div class="content">
                                <div class="counterup-item__number">
                                    <h5 class="counterup-item__title"><span class="odometer"
                                            data-odometer-final="<?php echo e(__(@$counter->data_values->digit)); ?>"></span>
                                        <?php if($loop->iteration == 3): ?>
                                            <?php echo app('translator')->get('Minute'); ?>
                                        <?php else: ?>
                                            <?php echo app('translator')->get('Million'); ?>
                                        <?php endif; ?>
                                    </h5>
                                </div>
                                <span class="counterup-item__text mb-0">
                                    <?php echo e(__(@$counter->data_values->content)); ?></span>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <?php echo $__env->make('Template::partials.empty', ['message' => 'Facilities not found!'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/joinvegk/brandmasters.academy/core/resources/views/templates/basic/sections/top_freelancer.blade.php ENDPATH**/ ?>